# 鱼皮的 AI 指南 - 1、AI 核心概念

> ⭐️ 推荐观看视频版：[https://www.bilibili.com/video/BV1i9Z8YhEja](https://www.bilibili.com/video/BV1i9Z8YhEja/)


首先，我会通过带大家实操一个主流的 AI 应用开发平台 [Dify](https://dify.ai/)，把 AI 的核心概念串联起来，更高效直观地带大家理解。

首先进入平台，创建一个 AI 应用，然后进入到了 AI 对话界面。

![](https://pic.yupi.icu/1/1743560753186-1e9452e6-0d38-4070-b369-c674bc418c91.png)

首次使用时，我们要选择 **大模型**（LLM）。大模型是 AI 的大脑，是指具有海量参数的人工智能模型，通过大规模的预训练获得广泛的知识和能力。

![](https://pic.yupi.icu/1/1743560803824-ab33d9d9-e994-45e5-8190-fc104e679747.png)

不同大模型的参数规模、处理能力、接受的对话长度是不一样的。

![](https://pic.yupi.icu/1/1743560841202-c37cde5b-0b25-4ebb-adff-3ab66af35d75.png)

选择大模型后，我们可以设置参数来调整大模型的输出，比如 **温度** 可以控制模型输出的随机性，温度值越高，模型输出越随机多样；温度值越低，输出越确定保守。

![](https://pic.yupi.icu/1/1743560855583-7efaebb7-3552-4a5b-9787-adbb9acaddc6.png)

下面我们来和 AI 进行对话，输入给 AI 的内容我们称为 **提示词 Prompt**，用来引导模型生成特定内容或执行特定任务，提示词的质量直接决定了 AI 输出的准确度。

提示词又可以分为系统提示词和用户提示词，系统提示词可以整体约束 AI 输出的内容，一般需要提前设置；用户提示词则是用户自主输入的内容，随用随输。

![](https://pic.yupi.icu/1/1743560920031-d86572e4-b09e-46b4-8aa8-c734a96bec44.png)

我们进行一次对话后，会发现对话下方展示了 “花费 Token”。

![](https://pic.yupi.icu/1/1743561058442-beebd2ac-94a0-4f00-8e56-f819822247e1.png)

看到 “花费” 很多同学就慌了，啥是 Token 啊？Token 贵不贵啊？

**Token** 是大语言模型处理文本的基本单位，可能是单词或标点符号，模型的输入和输出都是按 [Token 计算](https://tiktoken.aigc2d.com/) 的，一般 Token 越多，成本越高、并且输出速度越慢。不同模型的计费都不太一样，一般 100 万 Token 要几十块钱吧。

![](https://pic.yupi.icu/1/1743561097206-472514a9-3d13-4408-b222-2207b00f611a.png)

让我们再来添加一个大模型，谷歌的 Gemini，这次它让我输入 **API Key**，不让我免费用了。没事，我们去大模型官方去申请一个调用秘钥，输入过来即可，之后的每次扣费都会记在这个 API Key 上。

![](https://pic.yupi.icu/1/1743561147038-33ce3662-02df-40f1-b174-9c9076861bf6.png)

模型添加成功后，可以看到 Gemini 也支持非常多不同的大模型，比如标准版和 Lite 轻量版。

![](https://pic.yupi.icu/1/1743561208978-e661368f-044f-423a-9bbd-5925295040df.png)

可以将轻量版简单地理解为蒸馏版本。在实际应用中，大模型可能因资源需求高而难以部署。采用 **模型蒸馏**，将复杂大模型的知识转移到更小模型中，就可以在保持模型性能的同时，减小模型体积，降低推理成本。

![](https://pic.yupi.icu/1/1743561253715-f28757b3-209c-4fe9-b602-32273c1ae8d5.png)

有些模型是具备 **多模态** 能力的，多模态大模型能够同时理解和处理多种类型的信息，比如文本、图像、音频和视频，实现图生文、文生图、文生视频等更智能的应用。

![](https://pic.yupi.icu/1/1743561411703-df0a7367-69b5-48ea-bb23-21fe8d76c8d2.png)

有些大模型还具备 **文档解析** 的能力，可以上传一个 PDF 文件作为 **上下文信息**，交给 AI 去总结。还记得几年前有个很火的爆款产品 ChatPDF，现在人人都能实现了。

![](https://pic.yupi.icu/1/1743561623719-2f694756-c117-499a-9430-3ee275a8a206.png)

但有时，大模型可能缺少了某些信息，比如让 AI 总结鱼皮写的《保姆级写简历指南》，它给的信息就不准确，怎么办呢？我们可以开启知识库功能，背后是 **RAG 检索增强生成** 技术，来利用外部知识库给 AI 补充知识。

![](https://pic.yupi.icu/1/1743561648847-337df359-2e2a-4e05-bec6-fdff52b3be1d.png)

首先创建知识库，上传知识文档：

![](https://pic.yupi.icu/1/1743561783744-1ddce7bb-802e-4feb-9e8f-7e0a83b4ad98.png)

对文本进行切分，可以自己设置分块的规则：

![](https://pic.yupi.icu/1/1743561816205-22494e52-c011-49fe-8537-3b7f0f441a51.png)

然后利用 **Embedding 嵌入** 技术，将文本、图像等数据转换为向量表示，并写入到向量数据库中。用户向 AI 提问时，会将问题转换成向量，从知识库中检索和问题相关的信息，再将这些信息和问题一起输入大模型进行处理，使大模型的回答更准确。

![](https://pic.yupi.icu/1/1743561872916-7971c368-14bd-49c2-9bd9-604973f469e3.png)

好，这样我们的 AI 应用就做完了，可以发布给别人用，也可以通过 **API** 接口，在自己的代码程序中通过网络请求来调用。

![](https://pic.yupi.icu/1/1743561915955-ad27735a-c927-4207-b769-03fda32081b6.png)

刚刚我们只是牛刀小试，做了个聊天助手罢了。但实际上现在 AI 的应用已经升级为 **智能体** 了。智能体是能够感知环境、进行推理、制定计划、做出决策并自主采取行动来实现目标的 AI 系统。

![](https://pic.yupi.icu/1/1743561972671-9c7ad13e-a467-4a08-ba14-711d4640939c.png)

我们可以给智能体提供 **工具**，比如网页搜索、查询天气、调用数据库等等，让智能体完成更复杂的任务。安装工具后，提供给智能体，它就会在需要的时候使用这个工具，比如从网上检索到内容，进行总结后再回复。这样一来，AI 的应用范围和能力边界将会是无限大。

![](https://pic.yupi.icu/1/1743562005435-e5ece3f2-5f4b-4729-b490-a1e51f1f006e.png)

当然，如果你用的 AI 大模型是个睿智，它可能不会用工具，所以我建议给智能体选用思考能力更强的推理模型。有些模型会使用 **思维链**（CoT）和 **ReAct** 技术，让模型先思考问题、推理分析并提出行动计划，然后再行动，再基于结果进一步推理。并且中间步骤和思考过程是公开可见的，让我们能够理解模型是如何得出结论的，让整个推理过程更透明。

- 思维链 CoT：在处理复杂问题时，模型直接给出答案可能缺乏逻辑性和可解释性。思维链技术（Chain of Thought, CoT）通过让模型详细介绍中间步骤和推理过程，使人们能够理解模型是如何得出结论的，让整个推理过程更透明。
- ReAct：结合推理（Reason）和行动（Act）的 AI 开发范式，模型先思考问题，推理分析并提出行动计划，然后执行行动，再基于结果进一步推理。这种循环能使 AI 能够更有效地解决复杂问题。



![](https://pic.yupi.icu/1/1743562152661-80fabf5f-07a4-4463-a980-67da980f0ede.png)

有时，单一的智能体并不能完成我们的任务，比如自动生成 100 个短视频、自动做个游戏并发布上线。这时我们可以使用 **智能体工作流**（Agentic Workflow），可以通过规划和编排，让智能体自由搭配功能，自动化实现各种复杂的任务。有点像可视化编程。

![](https://pic.yupi.icu/1/1743562195750-57a3b344-4282-4279-bd71-510f60fc17c6.png)

最后再分享一个最近很火的概念，叫 **MCP**（Model Context Protocol） 模型上下文协议，用于实现 AI 与外部工具或数据的标准化交互。

![](https://pic.yupi.icu/1/1743562215479-a19f8b1c-0190-41b4-8a2f-f508b24e74a7.png)

简单来说，利用 MCP 服务，我们可以更方便地给 AI 集成不同的工具和数据，增强 AI 应用的功能。首先安装 MCP Agent 策略，让智能体支持调用 MCP：

![](https://pic.yupi.icu/1/1743562275496-34bcb486-235d-4d97-bc5a-cdf00f59cff7.png)

然后可以去 MCP 大全网站找到我们需要的 [MCP 服务](https://mcp.so/server/time)，比如查询当前时间。

![](https://pic.yupi.icu/1/1743562325916-dbef66dc-d0d1-4a60-9bed-68691c462677.png)

再回到智能体工作流中，填写 MCP 服务器地址、调用 MCP 的指令和查询条件等信息，AI 就可以在需要的时候向 MCP 发送请求来完成数据啦。

![](https://pic.yupi.icu/1/1743562400230-79c99317-98f1-4579-8884-a5bf53623683.png)

OK，AI 核心概念讲完了，看到这里，你应该就超过了 70% 的同学。

